//
//  $Id: NSString_FJNStringEncodingUsingPHP.m 84 2008-03-18 13:25:05Z fujidana $
//
//  Copyright (c) 2006-2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the author nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "NSString_FJNStringEncodingUsingPHP.h"


@implementation NSString (FJNStringEncodingUsingPHP)

+ (id)stringWithContentsOfFile:(NSString *)path encodingGuessedByPHP:(NSStringEncoding *)enc error:(NSError **)error
{
	return [[[self alloc] initWithContentsOfFile:path
							encodingGuessedByPHP:enc
										   error:error] autorelease];
}

- (id)initWithContentsOfFile:(NSString *)path encodingGuessedByPHP:(NSStringEncoding *)enc error:(NSError **)error
{
//	NSString *code      = [NSString stringWithFormat:@"echo mb_detect_encoding(file_get_contents(\"%@\"), \"auto\");", path];
	NSString *code      = [NSString stringWithFormat:@"$content = file_get_contents(\"%@\");"
		@"echo mb_detect_encoding($content, \"ASCII,JIS,UTF-8,EUC-JP,SJIS\");", 
		path];
	NSArray  *arguments = [NSArray arrayWithObjects:@"php", @"-r", code, nil];
	NSTask   *task      = [[NSTask alloc] init];
	
	[task setLaunchPath:@"/usr/bin/env"];
	[task setArguments:arguments];
	[task setStandardOutput:[NSPipe pipe]];
	[task setStandardError:[NSPipe pipe]];
	
	[task launch];
	[task waitUntilExit];
	NSData		*outputData		= [[[task standardOutput] fileHandleForReading] readDataToEndOfFile];
	NSString	*outputString	= [[[NSString alloc] initWithData:outputData encoding:NSASCIIStringEncoding] autorelease];
	NSData		*errorData		= [[[task standardOutput] fileHandleForReading] readDataToEndOfFile];
	NSString	*errorString	= [[[NSString alloc] initWithData:errorData encoding:NSASCIIStringEncoding] autorelease];
	int			status			= [task terminationStatus];
	[task release];
	
	NSStringEncoding encoding;
	if ([outputString isEqualToString:@"ASCII"])
	{
		encoding = NSASCIIStringEncoding;
	}else if ([outputString isEqualToString:@"JIS"])
	{
		encoding = NSISO2022JPStringEncoding;
	}
	else if ([outputString isEqualToString:@"UTF-8"])
	{
		encoding = NSUTF8StringEncoding;
	}
	else if ([outputString isEqualToString:@"EUC-JP"])
	{
		encoding = NSJapaneseEUCStringEncoding;
	}
	else if ([outputString isEqualToString:@"SJIS"])
	{
		encoding = NSShiftJISStringEncoding;
	}
	else
	{
		if (error)
		{
			NSDictionary *userInfo = nil;
			if (errorString && [errorString length] > 0)
			{
				userInfo = [NSDictionary dictionaryWithObject:errorString forKey:NSLocalizedDescriptionKey];
			}
			*error = [NSError errorWithDomain:NSPOSIXErrorDomain
										 code:status
									 userInfo:userInfo];
		}
		[self release];
		return nil;
	}
	
	self = [self initWithContentsOfFile:path 
							   encoding:encoding
								  error:error];
	if (self != nil)
	{
		if (enc != NULL) *enc = encoding;
	}
	return self;
}

@end
